<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function sanitize_input($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Log the raw POST data
    error_log("Raw POST data: " . print_r($_POST, true));
    
    // Get and sanitize form data
    $package_name = sanitize_input($_POST['package_name'] ?? 'Not specified');

    // Get button states - convert string 'true'/'false' to boolean
    $button1_active = isset($_POST['button1_active']) ? filter_var($_POST['button1_active'], FILTER_VALIDATE_BOOLEAN) : false;
    $button2_active = isset($_POST['button2_active']) ? filter_var($_POST['button2_active'], FILTER_VALIDATE_BOOLEAN) : false;
    $lastbutton_active = isset($_POST['lastbutton_active']) ? filter_var($_POST['lastbutton_active'], FILTER_VALIDATE_BOOLEAN) : false;

    // Decode selected services safely
    $selected_services = isset($_POST['selected_services']) ? json_decode($_POST['selected_services'], true) : [];

    // Check if decoding failed
    if (!is_array($selected_services)) {
        $selected_services = [];
    }

    // Prepare email content
    $email_body = <<<EOT
New Logo Design Order Details:

Package Name: {$package_name}

Selected Services:
EOT;

    foreach ($selected_services as $service) {
        $email_body .= "\n- " . sanitize_input($service);
    }

    // PHPMailer setup
    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'nepaldesigntech@gmail.com';
        $mail->Password = 'izzj dggm gfig pfgh';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // Recipients
        $mail->setFrom('nepaldesigntech@gmail.com', 'Nepal Design Tech');
        // $mail->addAddress('adamsmartin@myyahoo.com', 'Adams');
                $mail->addAddress('p91sandhya@gmail.com', 'Adams');


        // Content
        $mail->isHTML(false);
        $mail->Subject = "New Logo Design Order - {$package_name}";
        $mail->Body = $email_body;

        // Send email
        $mail->send();
        $response = [
            'success' => true,
            'message' => 'Email sent successfully'
        ];
   
    } catch (Exception $e) {
        $response = [
            'success' => false,
            'message' => "Mailer Error: {$mail->ErrorInfo}"
            
        ];
        error_log("Mailer Error: " . $mail->ErrorInfo);
    }

    // Send JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
